#include "maindefs.h"
#include "msg_queues.h"
#include <usart.h>
#include "uart.h"
#include "xbee.h"

void uart_init() {
    // Configure the hardware USART device
#ifdef _BASE_STATION
    // UART1 TX RC6
    // UART1 RX RC7
    Open1USART(USART_TX_INT_OFF &   // Interrupt on TX off
            USART_RX_INT_OFF &      // Interrupt on RX on
            USART_ASYNCH_MODE &     // Operate in async mode
            USART_EIGHT_BIT &       // Operate in 8-bit mode
            USART_CONT_RX &         // Continuously recieve messages
            USART_BRGH_HIGH, 51);  // Set UART speed to 38400 baud (32MHz)

    // UART2 RX Pin RP5
    RPINR16 = 5;    // 5 is PPS RP5
    // UART2 TX Pin RP6
    RPOR6 = 5;  // 5 is TX2/CK2 (EUSART2 Asynchronous Transmit/Asynchronous Clock Output)

    Open2USART(USART_TX_INT_OFF &   // Interrupt on TX off
            USART_RX_INT_ON &      // Interrupt on RX on
            USART_ASYNCH_MODE &     // Operate in async mode
            USART_EIGHT_BIT &       // Operate in 8-bit mode
            USART_CONT_RX &         // Continuously recieve messages
            USART_BRGH_HIGH, 51);  // Set UART speed to 38400 baud (32MHz)
#endif
#ifdef _REMOTE
    // UART1 TX RC6
    // UART1 RX RC7
    Open1USART(USART_TX_INT_OFF &   // Interrupt on TX off
            USART_RX_INT_OFF &      // Interrupt on RX on
            USART_ASYNCH_MODE &     // Operate in async mode
            USART_EIGHT_BIT &       // Operate in 8-bit mode
            USART_CONT_RX &         // Continuously recieve messages
            USART_BRGH_HIGH, 64);  // Set UART speed to 38400 baud

    // UART2 RX Pin RP5
    RPINR16 = 5;    // 5 is PPS RP5
    // UART2 TX Pin RP6
    RPOR6 = 5;  // 5 is TX2/CK2 (EUSART2 Asynchronous Transmit/Asynchronous Clock Output)

    Open2USART(USART_TX_INT_OFF &   // Interrupt on TX off
            USART_RX_INT_ON &      // Interrupt on RX on
            USART_ASYNCH_MODE &     // Operate in async mode
            USART_EIGHT_BIT &       // Operate in 8-bit mode
            USART_CONT_RX &         // Continuously recieve messages
            USART_BRGH_HIGH, 64);  // Set UART speed to 38400 baud
#endif
}

void uart_recv_interrupt_handler() {
    if (DataRdy2USART()) {
        xbee_read_serial(Read2USART());
    }

    if (USART2_Status.OVERRUN_ERROR == 1) {
        // We've overrun the USART and must reset
        RCSTA1bits.CREN = 0;
        RCSTA1bits.CREN = 1;
        RCSTA2bits.CREN = 0;
        RCSTA2bits.CREN = 1;
        MQ_sendmsg_ToMainFromHigh(0, MSGTYPE_OVERRUN, (void *) 0);
    }
}